<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-project-innovation-initiative
* @subpackage libraries
* @filesource
*/ /** */

/**
* @package direct-project-innovation-initiative
* @subpackage libraries
*/ 
class JSON {
	protected $CI;

	public function __construct(){
		$this->CI = get_instance();
	}

	/**
	* Wrapper for the standard JSON decode method which triggers errors when things go wrong.
	* The standard {@link json_decode} method fails silently when it encounters formatting problems.  
	* We'd like it to trigger an informative PHP warning instead.
	* @param string
	* @param boolean
	* @param int
	* @param int
	* @return array|object
	*/
	public function decode($json, $assoc = false, $depth = 512, $options = 0){
		if(!is_string($json)) return $this->CI->error->should_be_a_string($json);
		if(!is_bool($assoc)) return $this->CI->error->should_be_a_boolean($assoc);
		if(!is_int($depth)) return $this->CI->error->should_be_an_integer($depth);
		if(!is_int($options)) return $this->CI->error->should_be_an_integer($options);
	
		$json = trim($json);
		$result = json_decode($json, $assoc, $depth, $options);
		if(json_last_error() != JSON_ERROR_NONE){
			$this->CI->error->warning('JSON decode error: '.json_last_error_msg(), 1);
		}
		return $result;
	}
	
	public function decode_as_array($json){
		$result = $this->decode($json, TRUE);
		//if we don't get an array back (because the json has errors) return an empty array 
		//json decode returns the json string if it fails to decode it, but that's not that helpful
		if(!is_array($result))
			return array();
		return $result;
	}
	
	public function decode_as_object($json){
		$result = $this->decode($json);
		//if we don't get an array back (because the json has errors) return an empty array 
		//json decode returns the json string if it fails to decode it, but that's not that helpfu
		if(!is_object($result))
			return (object)array();
		return $result;
	}
	
	/**
	* True if a string is correctly formatted JSON
	* @param string
	* @return boolean
	*/
	public function is_valid($json){
		if(!is_string($json)) return false;
		$json = trim($json);
		if(empty($json)) return false;
		json_decode($json);
		return json_last_error() == JSON_ERROR_NONE;
	}
	

}
/* End of file Service_Call.php */
/* Location: ./application/libraries/Service_Call.php */